;; This example will show how to execute a RSX command with parameters
;; outside BASIC.
;;
;;
;; e.g. 
;;
;; |REN,"<new filename>,"<old filename>"
;;
;; Steps:
;; 1. Find RSX command and store information to access it (address of function
;;    and "rom select")
;; 2. Initialise parameter buffer (pointed to by IX register), and number of parameters (in A register)
;; 3. Execute command.

org &8000



;; firmware function to find a RSX command by name
.kl_find_command equ &bcd4

;;----------------------------------------------------------------
;; STEP 1: Find "REN" command, store access information


ld hl,cmd_ren
call kl_find_command
ret nc

ld (ren_command),hl	;; store address of function
ld a,c
ld (ren_command+2),a	;; store "rom select" of function



;;----------------------------------------------------------------
;; STEP 2: Initialise parameter buffer and number of parameters

ld ix,parameter_buffer	;; pointer to start of parameter buffer
ld a,2			;; number of parameters

;; store address of string descriptor block for old filename (2nd parameter)
ld hl,sdb_old_filename
ld (ix+0),l
ld (ix+1),h

;; store address of string descriptor block for new filename (1st parameter)
ld hl,sdb_new_filename
ld (ix+2),l
ld (ix+3),h

;;----------------------------------------------------------------
;; STEP 3: Execute REN command with parameters

rst 3			;; KL FAR CALL
defw ren_command


;;----------------------------------------------------------------
ret

;;-------------------------------------------------------------
;; This is initialised if the "REN" command is found.
;; this data is used to access command via "RST 3: KL FAR CALL"

.ren_command
defw 0			;; address of function
defb 0			;; "rom select" to access function

;;-------------------------------------------------------------

;; the name of the function 
;; - AMSDOS command "REN" (rename a file)
.cmd_ren
defb "RE","N"+&80

;;-------------------------------------------------------------

;; the parameter buffer:
;; - 2 bytes per parameter:
;;   integer constant: the constant
;;   integer variable: address of 2-byte integer variable
;;   string: address of string descriptor block
;;   real: address of 5-byte real number

;; - parameters are stored in reverse order (last parameter is first
;; in the buffer, first parameter is last in the buffer)

.parameter_buffer
defs 4			;; space for 2 parameters


;;-------------------------------------------------------------
;; the string descriptor blocks for the parameters

;; string descriptor block for old filename
.sdb_old_filename
defb end_old_filename-old_filename		;; length of string
defw old_filename				;; address of string

;; string descriptor block for new filename
.sdb_new_filename
defb end_new_filename-new_filename		;; length of string
defw new_filename				;; address of string

;;-------------------------------------------------------------

;; the old filename
.old_filename
defb "SCREEN.BIN"
.end_old_filename

;; the new filename
.new_filename
defb "SCREEN.SCR"
.end_new_filename
